<?php defined('SYSPATH') or die('No direct script access.');

class Task_Serverstats_Update_CountLogpostsDbEstimate extends Minion_Task
{

    const UPDATE_PERIOD = 60;
    
	protected function _execute(array $params)
    {
        Task_Helper::createWorker('Serverstats:Update:CountLogpostsDbEstimate', $this);
	}

    public function Worker(GearmanJob $job)
    {
        $serverstat = ORM::factory('Serverstat', 'CountLogpostsDbEstimate');
        
        if ( null === $serverstat->updated_at || time() - strtotime($serverstat->updated_at) > self::UPDATE_PERIOD )
        {
            $countLogpostsDbEstimate = Helper::countRowsEstimated('logpost');
            $platform = preg_replace('/^mysqli$/', 'mysql', strtolower(Kohana::$config->load('database.' . Database::$default . '.type')));

            Model_Serverstat::setStat('CountLogpostsDbEstimate', $countLogpostsDbEstimate, array(':platform' => $platform));
        }
    }
    
}